
static bool DicFind_Restart;

#define FindMaxLen (256)

static UnicodeChar DicFind_InputStr[FindMaxLen+1];

typedef struct {
  bool CanRestore;
  UnicodeChar InputStr[FindMaxLen+1];
  u32 BackSpaceCount;
} TDicFind_Backup;

static TDicFind_Backup DicFind_Backup;

static void DicFind_Init(void)
{
  DicFind_Restart=false;
  DicFind_InputStr[0]=0;
  
  TDicFind_Backup *pdfb=&DicFind_Backup;
  pdfb->CanRestore=false;
}

static void DicFind_Free(void)
{
  DicFind_Init();
}

void DicFind_Clear(void)
{
  DicFind_Restart=false;
  DicFind_InputStr[0]=0;
  
  DicResults_Free();
  
  DicFind_Restart=true;
}

static void DicFind_Backup_Clear(void)
{
//  _consolePrintf("Call DicFind_Backup_Clear();\n");
  TDicFind_Backup *pdfb=&DicFind_Backup;
  pdfb->CanRestore=false;
}

static void DicFind_Backup_Set(u32 BackSpaceCount)
{
  _consolePrintf("Call DicFind_Backup_Set(%d);\n",BackSpaceCount);
  TDicFind_Backup *pdfb=&DicFind_Backup;
  pdfb->CanRestore=true;
  Unicode_Copy(pdfb->InputStr,DicFind_InputStr);
  pdfb->BackSpaceCount=BackSpaceCount;
}

static bool DicFind_Backup_Restore(void)
{
//  _consolePrintf("Call DicFind_Backup_Restore();\n");
  
  TDicFind_Backup *pdfb=&DicFind_Backup;
  if(pdfb->CanRestore==false) return(false);
  
  _consolePrintf("Execute DicFind_Backup_Restore();\n");
  
  pdfb->CanRestore=false;
  Unicode_Copy(DicFind_InputStr,pdfb->InputStr);
  for(u32 idx=0;idx<pdfb->BackSpaceCount;idx++){
    TextEdit_Del();
  }
  
  DicFind_Restart=true;
  
  return(true);
}

static void DicFind_DrawInputStr(CglCanvas *pcan,const char *pOverwriteMessage)
{
  if(pOverwriteMessage==NULL){
    if(DicFind_InputStr[0]==0) return;
  }
  
  u32 y=0;
  
  pcan->SetColor(RGB15(31,31,31)|BIT15);
  pcan->FillBox(0,y,ScreenWidth,glCanvasTextHeight+2);
  
  if(pOverwriteMessage==NULL){
    TResultsWindow *prw=&ResultsWindow;
    if(prw->SelectIndex==(u32)-1){
      u32 tw=pcan->GetTextWidthW(DicFind_InputStr);
      pcan->SetColor(RGB15(20,20,31)|BIT15);
      pcan->FillBox(0,y,2+tw+2,glCanvasTextHeight+2);
    }
  }
  
  pcan->SetFontTextColor(RGB15(0,0,0)|BIT15);
  if(pOverwriteMessage!=NULL){
    pcan->TextOutA(2,1+y,pOverwriteMessage);
    }else{
    pcan->TextOutW(2,1+y,DicFind_InputStr);
  }
  y+=glCanvasTextHeight+2;
  
  pcan->SetColor(RGB15(0,0,0)|BIT15);
  pcan->DrawLine(0,y,ScreenWidth,y);
  y++;
}

UnicodeChar DicFind_GetLastWChar(void)
{
  const UnicodeChar *pstr=DicFind_InputStr;
  
  if(pstr[0]==0) return(0);
  
  while(1){
    if(*pstr==0) break;
    pstr++;
  }
  
  return(pstr[-1]);
}

static void DicFind_Add_ins_ChangeToKogaki(UnicodeChar *pstr)
{
  UnicodeChar wc=*pstr;
  
  if(wc==/**/ 0x3042) wc=/**/ 0x3041;
  if(wc==/**/ 0x3044) wc=/**/ 0x3043;
  if(wc==/**/ 0x3046) wc=/**/ 0x3045;
  if(wc==/**/ 0x3048) wc=/**/ 0x3047;
  if(wc==/**/ 0x304a) wc=/**/ 0x3049;
  if(wc==/**/ 0x3064) wc=/**/ 0x3063;
  if(wc==/**/ 0x3084) wc=/**/ 0x3083;
  if(wc==/**/ 0x3086) wc=/**/ 0x3085;
  if(wc==/**/ 0x3088) wc=/**/ 0x3087;
  
  if(wc==/*A*/ 0x30a2) wc=/*@*/ 0x30a1;
  if(wc==/*C*/ 0x30a4) wc=/*B*/ 0x30a3;
  if(wc==/*E*/ 0x30a6) wc=/*D*/ 0x30a5;
  if(wc==/*G*/ 0x30a8) wc=/*F*/ 0x30a7;
  if(wc==/*I*/ 0x30aa) wc=/*H*/ 0x30a9;
  if(wc==/*c*/ 0x30c4) wc=/*b*/ 0x30c3;
  if(wc==/**/ 0x30e4) wc=/**/ 0x30e3;
  if(wc==/**/ 0x30e6) wc=/**/ 0x30e5;
  if(wc==/**/ 0x30e8) wc=/**/ 0x30e7;
  
  if(wc!=0) *pstr=wc;
}

static void DicFind_Add_ins_ChangeToDakuten(UnicodeChar *pstr)
{
  UnicodeChar wc=*pstr;
  
  if(wc==/**/ 0x304B) wc=/**/ 0x304C;
  if(wc==/**/ 0x304D) wc=/**/ 0x304E;
  if(wc==/**/ 0x304F) wc=/**/ 0x3050;
  if(wc==/**/ 0x3051) wc=/**/ 0x3052;
  if(wc==/**/ 0x3053) wc=/**/ 0x3054;
  if(wc==/**/ 0x3055) wc=/**/ 0x3056;
  if(wc==/**/ 0x3057) wc=/**/ 0x3058;
  if(wc==/**/ 0x3059) wc=/**/ 0x305A;
  if(wc==/**/ 0x305B) wc=/**/ 0x305C;
  if(wc==/**/ 0x305D) wc=/**/ 0x305E;
  if(wc==/**/ 0x305F) wc=/**/ 0x3060;
  if(wc==/**/ 0x3061) wc=/**/ 0x3062;
  if(wc==/**/ 0x3064) wc=/**/ 0x3065;
  if(wc==/**/ 0x3066) wc=/**/ 0x3067;
  if(wc==/**/ 0x3068) wc=/**/ 0x3069;
  if(wc==/**/ 0x306F) wc=/**/ 0x3070;
  if(wc==/**/ 0x3072) wc=/**/ 0x3073;
  if(wc==/**/ 0x3075) wc=/**/ 0x3076;
  if(wc==/**/ 0x3078) wc=/**/ 0x3079;
  if(wc==/**/ 0x307B) wc=/**/ 0x307c;
  
  if(wc==/*E*/ 0x30a6) wc=/**/ 0x30f4;
  if(wc==/*J*/ 0x30aB) wc=/*K*/ 0x30aC;
  if(wc==/*L*/ 0x30aD) wc=/*M*/ 0x30aE;
  if(wc==/*N*/ 0x30aF) wc=/*O*/ 0x30b0;
  if(wc==/*P*/ 0x30b1) wc=/*Q*/ 0x30b2;
  if(wc==/*R*/ 0x30b3) wc=/*S*/ 0x30b4;
  if(wc==/*T*/ 0x30b5) wc=/*U*/ 0x30b6;
  if(wc==/*V*/ 0x30b7) wc=/*W*/ 0x30b8;
  if(wc==/*X*/ 0x30b9) wc=/*Y*/ 0x30bA;
  if(wc==/*Z*/ 0x30bB) wc=/*[*/ 0x30bC;
  if(wc==/*\*/ 0x30bD) wc=/*]*/ 0x30bE;
  if(wc==/*^*/ 0x30bF) wc=/*_*/ 0x30c0;
  if(wc==/*`*/ 0x30c1) wc=/*a*/ 0x30c2;
  if(wc==/*c*/ 0x30c4) wc=/*d*/ 0x30c5;
  if(wc==/*e*/ 0x30c6) wc=/*f*/ 0x30c7;
  if(wc==/*g*/ 0x30c8) wc=/*h*/ 0x30c9;
  if(wc==/*n*/ 0x30cF) wc=/*o*/ 0x30d0;
  if(wc==/*q*/ 0x30d2) wc=/*r*/ 0x30d3;
  if(wc==/*t*/ 0x30d5) wc=/*u*/ 0x30d6;
  if(wc==/*w*/ 0x30d8) wc=/*x*/ 0x30d9;
  if(wc==/*z*/ 0x30dB) wc=/*{*/ 0x30dc;
  
  if(wc!=0) *pstr=wc;
}

static void DicFind_Add_ins_ChangeToHanDakuten(UnicodeChar *pstr)
{
  UnicodeChar wc=*pstr;
  
  if(wc==/**/ 0x306F) wc=/**/ 0x3071;
  if(wc==/**/ 0x3072) wc=/**/ 0x3074;
  if(wc==/**/ 0x3075) wc=/**/ 0x3077;
  if(wc==/**/ 0x3078) wc=/**/ 0x307A;
  if(wc==/**/ 0x307B) wc=/**/ 0x307D;
  
  if(wc==/*n*/ 0x30cF) wc=/*p*/ 0x30d1;
  if(wc==/*q*/ 0x30d2) wc=/*s*/ 0x30d4;
  if(wc==/*t*/ 0x30d5) wc=/*v*/ 0x30d7;
  if(wc==/*w*/ 0x30d8) wc=/*y*/ 0x30dA;
  if(wc==/*z*/ 0x30dB) wc=/*|*/ 0x30dD;
  
  if(wc!=0) *pstr=wc;
}

static void DicFind_Add(UnicodeChar wc)
{
  u32 idx=0;
  while(DicFind_InputStr[idx]!=0){
    idx++;
  }
  
  if(wc==/**/ 0x5c0f){
    if(idx==0) return;
    DicFind_Add_ins_ChangeToKogaki(&DicFind_InputStr[idx-1]);
    DicFind_Restart=true;
    return;
  }
  
  if(wc==/*J*/ 0x309B){
    if(idx==0) return;
    DicFind_Add_ins_ChangeToDakuten(&DicFind_InputStr[idx-1]);
    DicFind_Restart=true;
    return;
  }
  
  if(wc==/*K*/ 0x309C){
    if(idx==0) return;
    DicFind_Add_ins_ChangeToHanDakuten(&DicFind_InputStr[idx-1]);
    DicFind_Restart=true;
    return;
  }
  
  DicFind_InputStr[idx+0]=wc;
  DicFind_InputStr[idx+1]=0;
  DicFind_Restart=true;
}

static bool DicFind_Del(void)
{
  if(DicFind_InputStr[0]==0) return(false);
  
  u32 idx=0;
  while(DicFind_InputStr[idx]!=0){
    idx++;
  }
  DicFind_InputStr[idx-1]=0;
  DicFind_Restart=true;
  
  return(true);
}

static bool DicFind_Fix(void)
{
  if(DicFind_InputStr[0]==0) return(false);
  
  TextEdit_Add(DicFind_InputStr);
  
  DicFind_Clear();
  
  return(true);
}

static bool DicFind_Space(void)
{
  if(DicFind_Fix()==false) return(false);
  
  TextEdit_Space();
  return(true);
}

static bool DicFind_MoveCursor(u32 keys)
{
  if(DicFind_InputStr[0]==0) return(false);
  
  return(true);
}

const UnicodeChar* DicFind_Execute_ins_GetNumStr(const UnicodeChar *pstr)
{
  static UnicodeChar res[FindMaxLen+1];
  
  u32 idx=0;
  
  while(1){
    UnicodeChar wch=pstr[idx];
    
    if(wch==0) break;
    
    bool f=false;
    if(wch==UnicodeChar('0')) f=true;
    if(wch==UnicodeChar('1')) f=true;
    if(wch==UnicodeChar('2')) f=true;
    if(wch==UnicodeChar('3')) f=true;
    if(wch==UnicodeChar('4')) f=true;
    if(wch==UnicodeChar('5')) f=true;
    if(wch==UnicodeChar('6')) f=true;
    if(wch==UnicodeChar('7')) f=true;
    if(wch==UnicodeChar('8')) f=true;
    if(wch==UnicodeChar('9')) f=true;
    if(wch==UnicodeChar(',')) f=true;
    if(wch==UnicodeChar('.')) f=true;
    if(f==false) break;
    
    res[idx++]=wch;
  }
  
  res[idx]=0;
  return(res);
}

static bool DicFind_Execute_ins_Find_ins_Check_ins_CheckMatchRoma(const char SrcOkuriChar,const u8 TagOkuriBinChar)
{
  const u8 *pMatchList=NULL;
  
  if(SrcOkuriChar=='a'){
    const u8 ML[]={BC_a,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='i'){
    const u8 ML[]={BC_i,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='u'){
    const u8 ML[]={BC_u,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='e'){
    const u8 ML[]={BC_e,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='o'){
    const u8 ML[]={BC_o,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='k'){
    const u8 ML[]={BC_ka,BC_ki,BC_ku,BC_ke,BC_ko,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='g'){
    const u8 ML[]={BC_ga,BC_gi,BC_gu,BC_ge,BC_go,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='s'){
    const u8 ML[]={BC_sa,BC_si,BC_su,BC_se,BC_so,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='z'){
    const u8 ML[]={BC_za,BC_zi,BC_zu,BC_ze,BC_zo,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='t'){
    const u8 ML[]={BC_ta,BC_ti,BC_tu,BC_te,BC_to,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='d'){
    const u8 ML[]={BC_da,BC_di,BC_du,BC_de,BC_do,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='n'){
    const u8 ML[]={BC_na,BC_ni,BC_nu,BC_ne,BC_no,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='h'){
    const u8 ML[]={BC_ha,BC_hi,BC_hu,BC_he,BC_ho,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='b'){
    const u8 ML[]={BC_ba,BC_bi,BC_bu,BC_be,BC_bo,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='p'){
    const u8 ML[]={BC_pa,BC_pi,BC_pu,BC_pe,BC_po,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='m'){
    const u8 ML[]={BC_ma,BC_mi,BC_mu,BC_me,BC_mo,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='y'){
    const u8 ML[]={BC_ya,BC_yu,BC_yo,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='r'){
    const u8 ML[]={BC_ra,BC_ri,BC_ru,BC_re,BC_ro,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='w'){
    const u8 ML[]={BC_wa,0};
    pMatchList=ML;
  }
  if(SrcOkuriChar=='c'){
    pMatchList=NULL;
  }
  if(SrcOkuriChar=='j'){
    const u8 ML[]={BC_zi,0};
    pMatchList=ML;
  }
  
  if(pMatchList==NULL) return(false);
  
  while(1){
    u8 ml=*pMatchList++;
    if(ml==0) break;
    if(ml==TagOkuriBinChar) return(true);
  }
  
  return(false);
}

static bool DicFind_Execute_ins_Find_ins_Check_ins_CheckMatchJoshi(const u8 TagOkuriBinChar)
{
  const u8 *pMatchList=NULL;
  
  {
    const u8 ML[]={BC_ga,BC_ka,BC_de,BC_to,BC_na,BC_ni,BC_no,BC_ha,BC_he,BC_mo,BC_ya,BC_wo,0};
    pMatchList=ML;
  }
  
  if(pMatchList==NULL) return(false);
  
  while(1){
    u8 ml=*pMatchList++;
    if(ml==0) break;
    if(ml==TagOkuriBinChar) return(true);
  }
  
  return(false);
}

static bool DicFind_Execute_ins_Find_LastMatchFlag;

static void DicFind_Execute_ins_Find_ins_Check(
  const u8 *pFindBinStr,const u32 FindBinStrLen,
  const u32 DicIndex,const u32 Flags,const u32 AddRate,
  const u8 *pSrcStr,const u32 SrcStrLen,const char OkuriChar,
  const u32 DstStrOffset
)
{
  if(DicFind_Execute_ins_Find_LastMatchFlag==false){
    if((Flags&DicItem_Flags_isLastEqual)!=0) return;
  }
  DicFind_Execute_ins_Find_LastMatchFlag=false;
  
  s32 Rate=AddRate+DicUser_GetRate(DicIndex);
  if(FindBinStrLen<=SrcStrLen){
    Rate+=FindBinStrLen-SrcStrLen;
    }else{
    const u32 OkuriBinStrLen=FindBinStrLen-SrcStrLen;
    Rate+=-(OkuriBinStrLen*2);
  }
  
  if(FindBinStrLen==1){
    if((Flags&DicItem_Flags_isTanKanji)==0){
      if(Rate<0) return;
    }
  }
  
  {
    u32 len=FindBinStrLen;
    if(SrcStrLen<len) len=SrcStrLen;
    for(u32 idx=0;idx<len;idx++){
      if(pFindBinStr[idx]!=pSrcStr[idx]) return;
    }
  }
  
  if(FindBinStrLen<=SrcStrLen){
    const u8 *pOkuriBinStr=DicUser_GetOkuriBinStr(DicIndex);
    u32 len=0;
    if(pOkuriBinStr!=NULL){
      while(pOkuriBinStr[len]!=0){
        len++;
      }
    }
    DicResults_Add(DicIndex,Flags,Rate,DstStrOffset,pOkuriBinStr,len);
    DicFind_Execute_ins_Find_LastMatchFlag=true;
    return;
  }
  
  const u8 *pOkuriBinStr=&pFindBinStr[SrcStrLen];
  const u32 OkuriBinStrLen=FindBinStrLen-SrcStrLen;
  const u8 OkuriBinChar=pOkuriBinStr[0];
  
  if(OkuriChar==0){
    if(2<=OkuriBinStrLen) return;
    if((Flags&DicItem_Flags_isTanKanji)!=0) return;
    if(DicFind_Execute_ins_Find_ins_Check_ins_CheckMatchJoshi(OkuriBinChar)==false) return;
    DicResults_Add(DicIndex,Flags,Rate,DstStrOffset,pOkuriBinStr,OkuriBinStrLen);
    DicFind_Execute_ins_Find_LastMatchFlag=true;
    return;
  }
  
  if(DicFind_Execute_ins_Find_ins_Check_ins_CheckMatchRoma(OkuriChar,OkuriBinChar)==false) return;
  
  DicResults_Add(DicIndex,Flags,Rate,DstStrOffset,pOkuriBinStr,OkuriBinStrLen);
  DicFind_Execute_ins_Find_LastMatchFlag=true;
}

static void DicFind_Execute_ins_Find(const u8 *pFindBinStr,const u32 FindBinStrLen)
{
  TDicState *pds=&DicState;
  
  if(pds->pBuf!=NULL){
    pFindResults=(TFindResult*)safemalloc(&MM_SKKDic,sizeof(TFindResult)*FindResultsMaxCount);
    
    u32 DicIndex=pds->TopDicIndex;
    u8 *pBuf=pds->pBuf;
    
    DicFind_Execute_ins_Find_LastMatchFlag=true;
    
    u8 *pSrcStr=NULL;
    u32 SrcStrLen=0;
    
    while(1){
      TDicItem *pdi=(TDicItem*)pBuf;
      pBuf+=6;
      
      if((pdi->Flags&DicItem_Flags_EndOfDic)!=0){
        _consolePrintf("End of dic.\n");
        break;
      }
      
      char OkuriChar=pdi->OkuriChar;
      
      u32 temp=pdi->SrcStrLen;
      u32 AddRate=temp>>6;
      temp&=0x3f;
      
      if(temp==0){
        }else{
        pSrcStr=pBuf;
        SrcStrLen=temp;
        pBuf+=SrcStrLen;
      }
      
      u32 DstStrOffset=(pdi->DstStrOffset24[0]<<0)|(pdi->DstStrOffset24[1]<<8)|(pdi->DstStrOffset24[2]<<16);
      
      DicFind_Execute_ins_Find_ins_Check(pFindBinStr,FindBinStrLen,DicIndex,pdi->Flags,AddRate,pSrcStr,SrcStrLen,OkuriChar,DstStrOffset);
      
      DicIndex++;
    }
    
    pFindResults=(TFindResult*)saferealloc(&MM_SKKDic,pFindResults,sizeof(TFindResult)*FindResultsCount);
  }
}

static void DicFind_Execute_ins_Sort(void)
{
  if(FindResultsCount<2) return;
  
  s32 min=10000;
  s32 max=-10000;
  
  for(u32 idx=0;idx<FindResultsCount;idx++){
    TFindResult *pfr=&pFindResults[idx];
    s32 rate=pfr->Rate;
    if(rate<min) min=rate;
    if(max<rate) max=rate;
  }
  
  for(u32 idx=0;idx<FindResultsCount;idx++){
    TFindResult *pfr=&pFindResults[idx];
    pfr->Rate-=min;
  }
  
  max-=min;
  
  u32 restmpcnt=FindResultsCount;
  TFindResult *prestmp=(TFindResult*)safemalloc(&MM_Temp,sizeof(TFindResult)*restmpcnt);
  MemCopy32CPU(pFindResults,prestmp,sizeof(TFindResult)*restmpcnt);
  
  if(false){ // verbose
    _consolePrintf("RateInfo: min=%d, max=%d.\n",min,max+min);
    for(s32 level=max;level>=0;level--){
      u32 cnt=0;
      for(u32 idx=0;idx<restmpcnt;idx++){
        TFindResult *pfr=&prestmp[idx];
        if((pfr->DicItem_Flags&DicItem_Flags_isTanKanji)==0){
          if(pfr->Rate==level) cnt++;
        }
      }
      if(cnt!=0) _consolePrintf("Rate=%d, Count=%d.\n",level+min,cnt);
    }
  }
  
  FindResultsCount=0;
  
  u32 LimitCount=64;
  if(isStrEqual(OSK_GlobalInfo.pOSK,"HandWrite")==false) LimitCount=32; // 菑̂Ƃ͑xdB
  
  for(s32 level=max;level>=0;level--){
    for(u32 idx=0;idx<restmpcnt;idx++){
      TFindResult *pfr=&prestmp[idx];
      if((pfr->DicItem_Flags&DicItem_Flags_isTanKanji)==0){
        if(pfr->Rate==level){
          bool isExists=false;
          const u32 DstStrOffset=pfr->DstStrOffset;
          for(u32 eidx=0;eidx<FindResultsCount;eidx++){
            if(pFindResults[eidx].DstStrOffset==DstStrOffset){
              isExists=true;
              break;
            }
          }
          if(isExists==false){
            pFindResults[FindResultsCount++]=prestmp[idx];
            prestmp[idx].pOkuriBinStr=NULL;
            if(FindResultsCount==LimitCount) break;
          }
        }
      }
    }
    if(FindResultsCount==LimitCount){
      _consolePrintf("Limited rate is %d.\n",level+min);
      break;
    }
  }
  
  LimitCount=FindResultsCount+LimitCount;
  const u32 FindResultsTopIndex=FindResultsCount;
  for(s32 level=max;level>=0;level--){
    for(u32 idx=0;idx<restmpcnt;idx++){
      TFindResult *pfr=&prestmp[idx];
      if((pfr->DicItem_Flags&DicItem_Flags_isTanKanji)!=0){
        if(pfr->Rate==level){
          bool isExists=false;
          const u32 DstStrOffset=pfr->DstStrOffset;
          for(u32 eidx=FindResultsTopIndex;eidx<FindResultsCount;eidx++){
            if(pFindResults[eidx].DstStrOffset==DstStrOffset){
              isExists=true;
              break;
            }
          }
          if(isExists==false){
            pFindResults[FindResultsCount++]=prestmp[idx];
            prestmp[idx].pOkuriBinStr=NULL;
            if(FindResultsCount==LimitCount) break;
          }
        }
      }
    }
    if(FindResultsCount==LimitCount) break;
  }
  
  for(u32 idx=0;idx<restmpcnt;idx++){
    if(prestmp[idx].pOkuriBinStr!=NULL){
      safefree(&MM_SKKDic,prestmp[idx].pOkuriBinStr); prestmp[idx].pOkuriBinStr=NULL;
    }
  }
  
  if(prestmp!=NULL){
    safefree(&MM_Temp,prestmp); prestmp=NULL;
  }
  
  pFindResults=(TFindResult*)saferealloc(&MM_SKKDic,pFindResults,sizeof(TFindResult)*FindResultsCount);
}

bool DicFind_isInputStrNULL(void)
{
  if(DicFind_InputStr[0]==0) return(true);
  return(false);
}

static bool DicFind_Execute(void)
{
  if(DicFind_Restart==false) return(true);
  DicFind_Restart=false;
  
  DicResults_Free();
  
  const UnicodeChar *pFindStr=DicFind_InputStr;
  
  pFindResultNumStr=DicFind_Execute_ins_GetNumStr(pFindStr);
  
  bool NumMode;
  {
    u32 len=Unicode_GetLength(pFindResultNumStr);
    if(len==0){
      NumMode=false;
      }else{
      NumMode=true;
    }
    pFindStr+=len;
  }
  
  if(pFindStr[0]==0) return(true);
  
  u8 FindBinStr[FindMaxLen+1];
  u32 FindBinStrLen=0;
  while(1){
    UnicodeChar wc=pFindStr[FindBinStrLen];
    if(wc==0) break;
    u32 bc=(u32)-1;
    for(u32 idx=0;idx<WideToBinTableCount;idx++){
      if(WideToBinTable[idx]==wc){
        bc=idx;
        break;
      }
    }
    if(bc==(u32)-1) return(true); // Interrupt for illigal widechars.
    FindBinStr[FindBinStrLen++]=bc;
  }
  FindBinStr[FindBinStrLen]=0;
  
  if(NumMode==true){
    if(DicSystem_Load(WC_Sharp)==false) return(false);
    }else{
    if(DicSystem_Load(pFindStr[0])==false) return(false);
  }
  
//  DicItem_ShowAll();
  
  DicFind_Execute_ins_Find(FindBinStr,FindBinStrLen);
  
  if(GetPenDown()==true){
    _consolePrintf("Canceled.\n");
    DicResults_Free();
    return(false);
  }
  
  _consolePrintf("Total results: %d.\n",FindResultsCount);
  
  DicFind_Execute_ins_Sort();
  
  DicResults_SetWindowParams();
  
  RequestRedrawSubFlag=true;
  
  PrintFreeMem_Accuracy_Already();
  
  return(true);
}

